/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.visitor.build.xml;

import DE.siemens.ad.logo.model.AnalogOrBlockReference;
import DE.siemens.ad.logo.model.AstronomicalClockParameter;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.CamParameter;
import DE.siemens.ad.logo.model.ClockHours;
import DE.siemens.ad.logo.model.ClockParameter;
import DE.siemens.ad.logo.model.HighResolutionSeconds;
import DE.siemens.ad.logo.model.Hours;
import DE.siemens.ad.logo.model.HoursCounterParameter;
import DE.siemens.ad.logo.model.IntegerOrBlockReference;
import DE.siemens.ad.logo.model.Minutes;
import DE.siemens.ad.logo.model.Mode;
import DE.siemens.ad.logo.model.Months;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemIdentifierTableLogo7;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.ProtectionParameter;
import DE.siemens.ad.logo.model.Reference;
import DE.siemens.ad.logo.model.Remanence;
import DE.siemens.ad.logo.model.Seconds;
import DE.siemens.ad.logo.model.TimeBase;
import DE.siemens.ad.logo.model.TimeUnit;
import DE.siemens.ad.logo.model.UnlimitedHours;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.visitor.build.Visitor;
import DE.siemens.ad.logo.model.visitor.build.xml.CompileParameterFromXml;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.CodeBlock;
import DE.siemens.ad.logo.util.DoubleValueProperties;
import DE.siemens.ad.logo.util.IntValueProperties;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.TimeValueProperties;
import org.dom4j.Element;

public class CompileParameterFromXmlLogo
extends Visitor
implements CompileParameterFromXml {
    private static CompileParameterFromXmlLogo fInstance;
    protected Block fBlock;
    protected Element fParameterNode;
    protected ParameterItem fParameterItem;
    protected Element fParamItemNode;
    protected static String DECLMAL_PLACE_IDENTIFIER;

    protected CompileParameterFromXmlLogo() {
    }

    public void compile(Block block, Element blockNode) {
        this.fBlock = block;
        this.fParameterNode = blockNode.element("Parameter");
        ParameterItemList list = block.getParameter().getParameterItems().getParameterItemListOfType(0).instance(block.getParameter());
        for (int i = 0; i < list.size(); ++i) {
            this.fParameterItem = (ParameterItem)list.get(i);
            if (block.getParameter() instanceof HoursCounterParameter && this.fParameterItem.getIdentifier().equals("MI")) continue;
            ParameterItemIdentifierTableLogo7 identifierTable = (ParameterItemIdentifierTableLogo7)this.fBlock.getWiringDiagram().getHardware().getProperty("parameterItemIdentifierTable");
            String identifier = identifierTable.getXmlIdentifier(this.fBlock.getParameter(), this.fParameterItem.getIdentifier());
            this.fParamItemNode = this.fParameterNode.element(identifier);
            CodeBlock codeBlock = new CodeBlock(this, "visit");
            try {
                Class<?> classname = this.fParameterItem.getGetMethod().getReturnType();
                codeBlock.addParameter(classname.getName(), null);
                codeBlock.execMethod();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new NoSuchMethodError();
            }
        }
        if (block.getParameter() instanceof ProtectionParameter) {
            ((ProtectionParameter)block.getParameter()).setProtection(Boolean.valueOf(this.fParameterNode.element("Protection").getText()));
        }
        if (block.getParameter() instanceof AstronomicalClockParameter) {
            ((AstronomicalClockParameter)block.getParameter()).setCity(this.fParameterNode.element("City").getText());
        }
    }

    public Object visit(IntValueProperties classType) {
        IntValueProperties ret = new IntValueProperties(Integer.valueOf(this.fParamItemNode.valueOf("@min")), Integer.valueOf(this.fParamItemNode.valueOf("@max")), Integer.valueOf(this.fParamItemNode.valueOf("@incre")), Integer.valueOf(this.fParamItemNode.getText()), "error.dialog.invalidValue", "Invalid value");
        this.fParameterItem.setValue(ret);
        return null;
    }

    public Object visit(AnalogValueProperties classType) {
        int decimalPlace = 0;
        try {
            decimalPlace = Integer.valueOf(this.fParameterNode.element(DECLMAL_PLACE_IDENTIFIER).getText());
        }
        catch (Exception e) {
            // empty catch block
        }
        AnalogValueProperties ret = new AnalogValueProperties(Integer.valueOf(this.fParamItemNode.valueOf("@min")), Integer.valueOf(this.fParamItemNode.valueOf("@max")), Integer.valueOf(this.fParamItemNode.valueOf("@incre")), Integer.valueOf(this.fParamItemNode.getText()), decimalPlace, true, "error.dialog.invalidValue", "Invalid value");
        this.fParameterItem.setValue(ret);
        return null;
    }

    public Object visit(IntegerOrBlockReference classType) {
        IntegerOrBlockReference ret = new IntegerOrBlockReference();
        ret.setParameter(this.fParameterItem.getParameter());
        int value = Integer.valueOf(this.fParamItemNode.getText());
        if (this.fParamItemNode.valueOf("@isReference").equals("true")) {
            ret.setReference(this.getReferencedParameterItem(value & 0xFF, value >> 8));
            value = 0;
        }
        IntValueProperties properties = new IntValueProperties(Integer.valueOf(this.fParamItemNode.valueOf("@min")), Integer.valueOf(this.fParamItemNode.valueOf("@max")), Integer.valueOf(this.fParamItemNode.valueOf("@incre")), value, "error.dialog.invalidValue", "Invalid value");
        ret.setIntValueProperties(properties);
        this.fParameterItem.setValue(ret);
        return null;
    }

    public Object visit(AnalogOrBlockReference classType) {
        AnalogOrBlockReference ret = new AnalogOrBlockReference();
        ret.setParameter(this.fParameterItem.getParameter());
        int value = Integer.valueOf(this.fParamItemNode.getText());
        if (this.fParamItemNode.valueOf("@isReference").equals("true")) {
            ret.setReference(this.getReferencedParameterItem(value & 0xFF, value >> 8));
            value = 0;
        }
        AnalogValueProperties properties = new AnalogValueProperties(Integer.valueOf(this.fParamItemNode.valueOf("@min")), Integer.valueOf(this.fParamItemNode.valueOf("@max")), Integer.valueOf(this.fParamItemNode.valueOf("@incre")), value, Integer.valueOf(this.fParameterNode.element(DECLMAL_PLACE_IDENTIFIER).getText()), true, "error.dialog.invalidValue", "Invalid value");
        ret.setAnalogValueProperties(properties);
        this.fParameterItem.setValue(ret);
        return null;
    }

    public Object visit(TimeValueProperties classType) {
        TimeValueProperties ret = new TimeValueProperties();
        ret.setParameter(this.fParameterItem.getParameter());
        int value = Integer.valueOf(this.fParamItemNode.getText());
        if (this.fParamItemNode.attributeValue("isReference").equals("true")) {
            Reference reference = new Reference();
            reference.setTimeUnit(this.getTimeObject(value & 0xFFFF));
            ret.setCurrentValue(reference);
            ret.setReference(this.getReferencedParameterItem((value & 0xFF0000) >> 16, value & 0x3FFF));
        } else {
            ret.setCurrentValue(this.getTimeObject(value));
        }
        TimeUnit tu = ret.getCurrentValue();
        tu.setLowMin(Integer.valueOf(this.fParamItemNode.attributeValue("lowMin")));
        tu.setLowMax(Integer.valueOf(this.fParamItemNode.attributeValue("lowMax")));
        tu.setHighMin(Integer.valueOf(this.fParamItemNode.attributeValue("highMin")));
        tu.setHighMax(Integer.valueOf(this.fParamItemNode.attributeValue("highMax")));
        this.fParameterItem.setValue(ret);
        return null;
    }

    public Object visit(AstronomicalClockParameter.Theodolite classType) {
        String value = this.fParamItemNode.getText();
        if (value.equals("")) {
            return null;
        }
        AstronomicalClockParameter.Theodolite theodolite = new AstronomicalClockParameter.Theodolite();
        if (value.charAt(0) == 'E' || value.charAt(0) == 'W') {
            theodolite.setType(0);
        } else {
            theodolite.setType(1);
        }
        if (value.charAt(0) == 'E' || value.charAt(0) == 'N') {
            theodolite.setDir(0);
        } else {
            theodolite.setDir(1);
        }
        theodolite.setDegree(Integer.parseInt(value.substring(1, value.indexOf("\u00b0"))));
        theodolite.setMinute(Integer.parseInt(value.substring(value.indexOf("\u00b0") + 1, value.indexOf("'"))));
        theodolite.setSecond(Integer.parseInt(value.substring(value.indexOf("'") + 1, value.indexOf("\""))));
        this.fParameterItem.setValue(theodolite);
        return null;
    }

    public Object visit(Remanence classType) {
        Remanence ret = new Remanence();
        ret.setParameter(this.fParameterItem.getParameter());
        ret.setRemanence(Boolean.valueOf(this.fParamItemNode.getText()));
        this.fParameterItem.setValue(ret);
        return null;
    }

    public Object visit(String classType) {
        String ret = new String(this.fParamItemNode.getText());
        this.fParameterItem.setValue(ret);
        return null;
    }

    public Object visit(Integer classType) {
        Integer ret = new Integer(this.fParamItemNode.getText());
        this.fParameterItem.setValue(ret);
        return null;
    }

    public Object visit(Boolean classType) {
        Boolean ret = new Boolean(this.fParamItemNode.getText());
        this.fParameterItem.setValue(ret);
        return null;
    }

    public Object visit(Mode classType) {
        ClockParameter parameter = (ClockParameter)this.fBlock.getParameter();
        int camNumber = Integer.valueOf(this.fParamItemNode.getName().trim().substring(1));
        CamParameter cam = parameter.getCam(camNumber);
        cam.setLogoMode(Integer.valueOf(this.fParamItemNode.getText()));
        return null;
    }

    public Object visit(Months classType) {
        Months months = new Months();
        months.setEveryMonth(Boolean.valueOf(this.fParamItemNode.attributeValue("monthly")));
        int value = Integer.valueOf(this.fParamItemNode.getTextTrim());
        months.setTime(value >> 16, value & 0xFFFF);
        this.fParameterItem.setValue(months);
        return null;
    }

    public Object visit(Character classType) {
        this.fParameterItem.setValue(new Character(this.fParamItemNode.getText().charAt(0)));
        return null;
    }

    public Object visit(DoubleValueProperties classType) {
        this.fParameterItem.setValue(new DoubleValueProperties(0.0, 99.99, 0.01, (double)Double.valueOf(this.fParamItemNode.getText()), 2, "error.pid.gain", "Wrong value in loop gain."));
        return null;
    }

    public Object visit(ClockHours classType) {
        ClockHours cH = new ClockHours();
        String[] value = this.fParamItemNode.getTextTrim().substring(0, 5).split(":");
        try {
            cH.setTime(Integer.valueOf(value[0]), Integer.valueOf(value[1]));
        }
        catch (Exception e) {
            // empty catch block
        }
        cH.setInactive(Boolean.parseBoolean(this.fParamItemNode.attributeValue("inactive")));
        this.fParameterItem.setValue(cH);
        return null;
    }

    public Object visit(TimeBase classType) {
        this.fParameterItem.setValue(new TimeBase(Integer.valueOf(this.fParamItemNode.attributeValue("key")), Integer.valueOf(this.fParamItemNode.getText())));
        return null;
    }

    protected TimeUnit getTimeObject(int value) {
        TimeUnit retValue = null;
        int timeBase = value & 0xC000;
        int timeValue = value & 0x3FFF;
        if ((value & 0x40000000) > 0) {
            timeBase = 16128;
            timeValue = value & 0x3FFFFFFF;
        }
        switch (timeBase) {
            case 0: {
                retValue = new ClockHours();
                retValue.setTime(timeValue / 60, timeValue % 60);
                break;
            }
            case 16384: {
                retValue = new HighResolutionSeconds();
                retValue.setTime(timeValue / 100, timeValue % 100);
                break;
            }
            case 32768: {
                retValue = new Minutes();
                retValue.setTime(timeValue / 60, timeValue % 60);
                break;
            }
            case 49152: {
                retValue = new Hours();
                retValue.setTime(timeValue / 60, timeValue % 60);
                break;
            }
            case 16128: {
                retValue = new UnlimitedHours();
                retValue.setTime(timeValue / 60, timeValue % 60);
                break;
            }
            default: {
                retValue = new Seconds();
                Log.out.println("Error calculating a new Time. I take a default Value of 0 seconds.");
            }
        }
        return retValue;
    }

    protected ParameterItem getReferencedParameterItem(int opcode, int blockNumber) {
        Block srcBlock = this.getBlock(opcode, blockNumber);
        ParameterItemList itemList = srcBlock.getParameter().getParameterItems().getParameterSourceItems();
        int size = itemList.size();
        if (size == 0 || size > 1) {
            InternalError e = new InternalError("Cannot connect to referencedItem because size of possible Items are more than 1");
            e.printStackTrace();
            throw e;
        }
        return ((ParameterItem)itemList.get(0)).getInstanceForParameter(srcBlock.getParameter());
    }

    protected Block getBlock(int opcode, int blockNumber) {
        WiringDiagram wd = this.fBlock.getWiringDiagram();
        Block result = wd.getBlock(opcode, blockNumber);
        if (result == null) {
            result = wd.createBlock(opcode, blockNumber);
        }
        return result;
    }

    public static CompileParameterFromXmlLogo getInstance() {
        if (fInstance == null) {
            fInstance = new CompileParameterFromXmlLogo();
        }
        return fInstance;
    }

    static {
        DECLMAL_PLACE_IDENTIFIER = "p";
    }
}

